/*
 * Decompiled with CFR 0.152.
 */
package bsearch.algorithms;

import bsearch.algorithms.AbstractSearchMethod;
import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.SearchSpace;
import java.util.Arrays;
import java.util.HashMap;
import org.nlogo.util.MersenneTwisterFast;

public strictfp class StandardGA
extends AbstractSearchMethod {
    private double mutationRate = 0.01;
    private double crossoverRate = 0.7;
    private int populationSize = 50;
    private int tournamentSize = 3;
    private String populationModel = "generational";

    @Override
    public String getName() {
        return "StandardGA";
    }

    @Override
    public String getDescription() {
        return "A standard Genetic Algorithm.";
    }

    @Override
    public void setSearchParams(HashMap<String, String> searchMethodParams) throws SearchParameterException {
        this.mutationRate = this.validDoubleParam(searchMethodParams, "mutation-rate", 0.0, 1.0);
        this.crossoverRate = this.validDoubleParam(searchMethodParams, "crossover-rate", 0.0, 1.0);
        this.populationSize = this.validIntParam(searchMethodParams, "population-size", 2, 1000);
        this.tournamentSize = this.validIntParam(searchMethodParams, "tournament-size", 2, 10);
        this.populationModel = this.validChoiceParam(searchMethodParams, "population-model", Arrays.asList("generational", "steady-state-replace-random", "steady-state-replace-worst"));
    }

    @Override
    public HashMap<String, String> getSearchParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mutation-rate", Double.toString(this.mutationRate));
        params.put("crossover-rate", Double.toString(this.crossoverRate));
        params.put("population-size", Integer.toString(this.populationSize));
        params.put("tournament-size", Integer.toString(this.tournamentSize));
        params.put("population-model", this.populationModel);
        return params;
    }

    @Override
    public HashMap<String, String> getSearchParamsHelp() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mutation-rate", "likelihood of mutation occurring in each child");
        params.put("crossover-rate", "probability of using two parents to create a child (otherwise child is created asexually)");
        params.put("population-size", "the number of individuals in each generation");
        params.put("tournament-size", "for tournament selection, this is the number of individuals that compete to choose an individual that gets to reproduce.");
        params.put("population-model", "'generational', 'steady-state-replace-random', or 'steady-state-replace-worst' -- generational means the whole population is replaced at once, whereas steady-state means that just a single individual is replaced by reproduction each iteration - either a randomly-chosen individual, or the current worst.");
        return params;
    }

    @Override
    public void search(SearchSpace space, ChromosomeFactory cFactory, SearchProtocol protocol, SearchManager manager, MersenneTwisterFast rng) throws BehaviorSearchException, NetLogoLinkException, InterruptedException {
        block12: {
            double[] fitness;
            Chromosome[] population;
            block11: {
                population = new Chromosome[this.populationSize];
                int i = 0;
                while (i < this.populationSize) {
                    population[i] = cFactory.createChromosome(space, rng);
                    ++i;
                }
                fitness = manager.computeFitnessBatch(population, protocol.fitnessSamplingReplications, rng);
                if (!this.populationModel.equals("generational")) break block11;
                Chromosome[] newpopulation = new Chromosome[this.populationSize];
                while (!manager.searchFinished()) {
                    int crossoverPairs = (int)(this.crossoverRate * (double)this.populationSize / 2.0);
                    int newPopIndex = 0;
                    int i2 = 0;
                    while (i2 < crossoverPairs) {
                        Chromosome p1 = manager.tournamentSelect(population, fitness, this.tournamentSize, rng);
                        Chromosome p2 = manager.tournamentSelect(population, fitness, this.tournamentSize, rng);
                        Chromosome[] children = p1.crossoverWith(p2, rng);
                        newpopulation[newPopIndex++] = children[0];
                        newpopulation[newPopIndex++] = children[1];
                        ++i2;
                    }
                    while (newPopIndex < this.populationSize) {
                        newpopulation[newPopIndex++] = manager.tournamentSelect(population, fitness, this.tournamentSize, rng);
                    }
                    i2 = 0;
                    while (i2 < this.populationSize) {
                        newpopulation[i2] = newpopulation[i2].mutate(this.mutationRate, rng);
                        ++i2;
                    }
                    Chromosome[] temp = population;
                    population = newpopulation;
                    newpopulation = temp;
                    fitness = manager.computeFitnessBatch(population, protocol.fitnessSamplingReplications, rng);
                }
                break block12;
            }
            if (!this.populationModel.startsWith("steady-state")) break block12;
            while (!manager.searchFinished()) {
                int replaceIndex;
                Chromosome child = manager.tournamentSelect(population, fitness, this.tournamentSize, rng);
                if (rng.nextDouble() < this.crossoverRate) {
                    Chromosome p2 = manager.tournamentSelect(population, fitness, this.tournamentSize, rng);
                    child = child.crossoverWith(p2, rng)[0];
                }
                child = child.mutate(this.mutationRate, rng);
                double childFitness = manager.computeFitnessSingle(child, protocol.fitnessSamplingReplications, rng);
                if (this.populationModel.equals("steady-state-replace-random")) {
                    replaceIndex = rng.nextInt(this.populationSize);
                } else {
                    double worstFitness = fitness[0];
                    replaceIndex = 0;
                    int i = 0;
                    while (i < this.populationSize) {
                        if (manager.fitnessStrictlyBetter(worstFitness, fitness[i])) {
                            replaceIndex = i;
                            worstFitness = fitness[i];
                        }
                        ++i;
                    }
                }
                population[replaceIndex] = child;
                fitness[replaceIndex] = childFitness;
            }
        }
    }
}

