/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearch;
import bsearch.app.BehaviorSearchGUI;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.ResultListener;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.ModelRunResult;
import bsearch.nlogolink.ModelRunner;
import bsearch.representations.Chromosome;
import bsearch.space.SearchSpace;
import bsearch.util.GeneralUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GUIProgressDialog
extends JDialog
implements PropertyChangeListener,
ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JLabel labelMessage;
    private JLabel labelTimeRemaining;
    private JTextPane infoTextPane;
    private JButton buttonCancel;
    private SearchTask task;
    private long taskStartTime;
    JFreeChart fitnessPlot;
    private XYSeriesCollection fitnessPlotDataset;
    private boolean done = false;

    public GUIProgressDialog(Frame parent) {
        super(parent, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.labelMessage = new JLabel("Performing search 0000 out of 0000");
        this.labelMessage.setFont(new Font("Arial", 1, 12));
        this.labelTimeRemaining = new JLabel("Elapsed: ? Remaining: ?");
        this.labelTimeRemaining.setFont(new Font("Arial", 0, 12));
        this.infoTextPane = new JTextPane();
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setBorder(BorderFactory.createEmptyBorder(30, 5, 10, 12));
        this.infoTextPane.setContentType("text/html");
        this.infoTextPane.setText("<B><I>Search result status</I></B><BR>");
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.fitnessPlotDataset = new XYSeriesCollection();
        this.fitnessPlot = ChartFactory.createXYLineChart("Search Progress", "# of model runs", "Fitness", this.fitnessPlotDataset, PlotOrientation.VERTICAL, true, false, false);
        XYPlot plot = this.fitnessPlot.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseShapesVisible(false);
        renderer.setBaseLegendTextFont(new Font("Arial", 0, 10));
        plot.setRenderer(renderer);
        ChartPanel cPanel = new ChartPanel(this.fitnessPlot);
        cPanel.setPreferredSize(new Dimension(500, 400));
        JPanel panelSouth = new JPanel();
        panelSouth.setLayout(new BorderLayout());
        panelSouth.add((Component)this.labelMessage, "West");
        panelSouth.add((Component)this.progressBar, "Center");
        panelSouth.add((Component)this.labelTimeRemaining, "East");
        panelSouth.add((Component)this.buttonCancel, "South");
        JPanel panelEast = new JPanel();
        panelEast.setLayout(new BorderLayout());
        panelEast.add((Component)new JScrollPane(this.infoTextPane), "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)panelEast, "East");
        panel.add((Component)cPanel, "Center");
        panel.add((Component)panelSouth, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
    }

    public void startSearchTask(SearchProtocol protocol, BehaviorSearch.RunOptions runOptions) {
        if (protocol.useBestChecking()) {
            ValueAxis rangeAxis = this.fitnessPlot.getXYPlot().getRangeAxis();
            rangeAxis.setLabel(String.valueOf(rangeAxis.getLabel()) + " (rechecked)");
        }
        this.labelMessage.setText("Search 0 of " + runOptions.numSearches);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMaximum(protocol.evaluationLimit);
        this.taskStartTime = System.currentTimeMillis();
        this.task = new SearchTask(protocol, runOptions);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
            try {
                if (this.task.isCancelled()) {
                    JOptionPane.showMessageDialog(this, "You canceled the search.  \nPartial results may have been saved to output files.", "Canceled", 2);
                } else if (this.task.fatalException != null) {
                    throw this.task.fatalException;
                }
            }
            catch (ModelRunner.ModelRunnerException e) {
                e.printStackTrace();
                BehaviorSearchGUI.handleError("Error running the model:\n" + e.getMessage(), this.getParent());
            }
            catch (SearchParameterException e) {
                e.printStackTrace();
                BehaviorSearchGUI.handleError("Error setting search method parameters:\n" + e.getMessage(), this.getParent());
            }
            catch (IOException e) {
                BehaviorSearchGUI.handleError("Error reading or writing files:\n" + e, this.getParent());
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                BehaviorSearchGUI.handleError("Error: " + e, this.getParent());
            }
            catch (Throwable e) {
                e.printStackTrace();
                BehaviorSearchGUI.handleError("Serious Error: " + e, this.getParent());
            }
            this.done = true;
            this.buttonCancel.setText("Done");
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.buttonCancel)) {
            this.doCancel();
        }
    }

    private void doCancel() {
        if (this.done) {
            this.setVisible(false);
        } else {
            this.progressBar.setIndeterminate(false);
            this.task.cancel(true);
        }
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.doCancel();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    class SearchTask
    extends SwingWorker<Void, Void>
    implements ResultListener {
        private SearchProtocol protocol;
        private BehaviorSearch.RunOptions runOptions;
        private Throwable fatalException = null;
        Chromosome overallBest = null;
        double overallBestFitness;
        double overallBestFitnessChecked;

        public SearchTask(SearchProtocol protocol, BehaviorSearch.RunOptions runOptions) {
            this.protocol = protocol;
            this.runOptions = runOptions;
        }

        public void updateGUIForNextSearch(final int searchNum) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUIProgressDialog.this.labelMessage.setText("Performing search " + (searchNum - ((SearchTask)SearchTask.this).runOptions.firstSearchNumber + 1) + " of " + ((SearchTask)SearchTask.this).runOptions.numSearches + ":  ");
                    GUIProgressDialog.this.progressBar.setValue(0);
                    XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)((SearchTask)SearchTask.this).GUIProgressDialog.this.fitnessPlot.getXYPlot().getRenderer();
                    if (searchNum > ((SearchTask)SearchTask.this).runOptions.firstSearchNumber) {
                        renderer.setSeriesStroke(searchNum - ((SearchTask)SearchTask.this).runOptions.firstSearchNumber - 1, new BasicStroke(1.0f));
                    }
                    renderer.setSeriesStroke(searchNum - ((SearchTask)SearchTask.this).runOptions.firstSearchNumber, new BasicStroke(3.0f));
                }
            });
        }

        public void updateGUIWhenFinished() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUIProgressDialog.this.labelMessage.setText("Finished search " + ((SearchTask)SearchTask.this).runOptions.numSearches + " of " + ((SearchTask)SearchTask.this).runOptions.numSearches + ":  ");
                    GUIProgressDialog.this.progressBar.setValue(GUIProgressDialog.this.progressBar.getMaximum());
                    XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)((SearchTask)SearchTask.this).GUIProgressDialog.this.fitnessPlot.getXYPlot().getRenderer();
                    renderer.setSeriesStroke(((SearchTask)SearchTask.this).runOptions.numSearches - 1, new BasicStroke(1.0f));
                }
            });
        }

        @Override
        public Void doInBackground() {
            try {
                ArrayList<ResultListener> listeners = new ArrayList<ResultListener>();
                listeners.add(this);
                BehaviorSearch.runWithOptions(this.runOptions, this.protocol, listeners);
                this.updateGUIWhenFinished();
            }
            catch (Throwable e) {
                this.fatalException = e;
            }
            return null;
        }

        @Override
        public void modelRunOccurred(SearchManager manager, Chromosome point, ModelRunResult result) {
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - GUIProgressDialog.this.taskStartTime;
            String elapsedStr = GeneralUtils.formatTimeNicely(elapsed);
            int searchesCompleted = manager.getSearchIDNumber() - this.runOptions.firstSearchNumber;
            int totalSearches = this.runOptions.numSearches;
            double runsCompleted = manager.getEvaluationCount() + manager.getAuxilliaryEvaluationCount();
            double totalRuns = this.protocol.evaluationLimit + manager.getAuxilliaryEvaluationCount();
            double searchProgress = ((double)searchesCompleted + runsCompleted / totalRuns) / (double)totalSearches;
            long remaining = (long)((double)elapsed / searchProgress - (double)elapsed);
            String remainingStr = GeneralUtils.formatTimeNicely(remaining);
            GUIProgressDialog.this.labelTimeRemaining.setText("  (" + elapsedStr + " elapsed - " + remainingStr + " remaining)");
        }

        @Override
        public void fitnessComputed(SearchManager manager, Chromosome point, double fitness) {
            final int searchNumber = manager.getSearchIDNumber();
            final double bestFitnessSoFar = this.protocol.useBestChecking() ? manager.getCurrentBestFitnessCheckedEstimate() : manager.getCurrentBestFitness();
            final int evaluationCount = manager.getEvaluationCount();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int itemCount;
                    XYSeries series;
                    GUIProgressDialog.this.progressBar.setIndeterminate(false);
                    GUIProgressDialog.this.progressBar.setValue(evaluationCount);
                    ValueAxis axis = ((SearchTask)SearchTask.this).GUIProgressDialog.this.fitnessPlot.getXYPlot().getDomainAxis();
                    if (axis.getRange().getUpperBound() < (double)(evaluationCount + 1)) {
                        axis.setRange(0.0, evaluationCount + 1);
                    }
                    if (searchNumber - ((SearchTask)SearchTask.this).runOptions.firstSearchNumber + 1 > GUIProgressDialog.this.fitnessPlotDataset.getSeriesCount()) {
                        series = new XYSeries((Comparable)((Object)("Search " + searchNumber)));
                        GUIProgressDialog.this.fitnessPlotDataset.addSeries(series);
                    }
                    if ((itemCount = (series = GUIProgressDialog.this.fitnessPlotDataset.getSeries(searchNumber - ((SearchTask)SearchTask.this).runOptions.firstSearchNumber)).getItemCount()) == 0 || evaluationCount > series.getX(itemCount - 1).intValue() || bestFitnessSoFar != series.getY(itemCount - 1).doubleValue()) {
                        if (itemCount > 1 && series.getY(itemCount - 1).doubleValue() == bestFitnessSoFar && series.getY(itemCount - 2).doubleValue() == bestFitnessSoFar) {
                            series.remove(itemCount - 1);
                        }
                        series.addOrUpdate(evaluationCount, bestFitnessSoFar);
                    }
                }
            });
        }

        private void updateInfoText(String title, Chromosome c, double fitness, double checkedFitness) {
            String bestText = GeneralUtils.getParamSettingsTextHTML(c.getParamSettings());
            StringBuilder sb = new StringBuilder();
            sb.append("<B><I>" + title + "</I></B>");
            sb.append("<BR><BR><B>Best found so far:</B><BR>");
            sb.append(bestText);
            sb.append("<BR><B>Fitness</B>=");
            sb.append(String.format("%10.6g", fitness));
            sb.append("<BR>");
            if (this.protocol.useBestChecking()) {
                sb.append("<B>(re-checked)</B>=");
                sb.append(String.format("%10.6g", checkedFitness));
                sb.append("<BR>");
            }
            GUIProgressDialog.this.infoTextPane.setText(sb.toString());
        }

        @Override
        public void newBestFound(SearchManager manager) {
            this.updateInfoText("In Search #" + manager.getSearchIDNumber() + ":", manager.getCurrentBest(), manager.getCurrentBestFitness(), manager.getCurrentBestFitnessCheckedEstimate());
        }

        @Override
        public void initListener(SearchSpace space) {
        }

        @Override
        public void searchStarting(SearchManager archive) {
            this.updateGUIForNextSearch(archive.getSearchIDNumber());
        }

        @Override
        public void searchFinished(SearchManager manager) {
            double bestFitness = manager.getCurrentBestFitness();
            if (this.overallBest == null || manager.fitnessStrictlyBetter(bestFitness, this.overallBestFitness)) {
                this.overallBest = manager.getCurrentBest();
                this.overallBestFitness = bestFitness;
                if (this.protocol.useBestChecking()) {
                    this.overallBestFitnessChecked = manager.getCurrentBestFitnessCheckedEstimate();
                }
            }
        }

        @Override
        public void allSearchesFinished() {
            this.updateInfoText("From all searches:", this.overallBest, this.overallBestFitness, this.overallBestFitnessChecked);
        }

        @Override
        public void searchesAborted() {
        }
    }
}

