/*
 * Decompiled with CFR 0.152.
 */
package bsearch.nlogolink;

import bsearch.nlogolink.ModelRunResult;
import bsearch.nlogolink.ModelRunner;
import bsearch.nlogolink.ModelRunnerTask;
import bsearch.nlogolink.NetLogoLinkException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BatchRunner {
    private ModelRunner.Factory factory;
    ExecutorService pool;
    private final int numThreads;

    public BatchRunner(int numThreads, ModelRunner.Factory factory) {
        this.factory = factory;
        this.numThreads = numThreads;
        this.pool = Executors.newFixedThreadPool(numThreads);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public List<ModelRunResult> doBatchRun(List<ModelRunner.RunSetup> setups) throws NetLogoLinkException, ModelRunner.ModelRunnerException, InterruptedException {
        ArrayList<ModelRunnerTask> tasks = new ArrayList<ModelRunnerTask>();
        for (ModelRunner.RunSetup setup : setups) {
            tasks.add(new ModelRunnerTask(this.factory, setup));
        }
        ArrayList<Future<ModelRunResult>> futures = new ArrayList<Future<ModelRunResult>>(tasks.size());
        ArrayList<ModelRunResult> results = new ArrayList<ModelRunResult>(tasks.size());
        try {
            for (ModelRunnerTask modelRunnerTask : tasks) {
                futures.add(this.pool.submit(modelRunnerTask));
            }
            for (Future future : futures) {
                results.add((ModelRunResult)future.get());
            }
            return results;
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NetLogoLinkException) {
                throw (NetLogoLinkException)executionException.getCause();
            }
            if (executionException.getCause() instanceof ModelRunner.ModelRunnerException) {
                throw (ModelRunner.ModelRunnerException)executionException.getCause();
            }
            executionException.printStackTrace();
            throw new NetLogoLinkException("Unexpected exception while attempting to run NetLogo", executionException);
        }
    }

    public void dispose() throws InterruptedException {
        this.pool.shutdownNow();
        this.factory.disposeAllRunners();
    }
}

