/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import org.nlogo.util.MersenneTwisterFast;

public strictfp class DoubleContinuousSpec
extends ParameterSpec {
    private double dMin;
    private double dMax;

    public DoubleContinuousSpec(String name, double min, double max) {
        super(name);
        this.dMin = min;
        this.dMax = max;
    }

    public double getMin() {
        return this.dMin;
    }

    public double getMax() {
        return this.dMax;
    }

    public double enforceValidRange(double d) {
        if (d < this.dMin) {
            return this.dMin;
        }
        if (d > this.dMax) {
            return this.dMax;
        }
        return d;
    }

    @Override
    public Double generateRandomValue(MersenneTwisterFast rng) {
        return rng.nextDouble() * (this.dMax - this.dMin) + this.dMin;
    }

    @Override
    public Double mutate(Object obj, double mutStrength, MersenneTwisterFast rng) {
        double mutStdDev = (this.dMax - this.dMin) * mutStrength;
        return this.enforceValidRange((Double)obj + mutStdDev * rng.nextGaussian());
    }

    @Override
    public int choiceCount() {
        return -1;
    }

    public String toString() {
        return "[ \"" + this.name + "\" [ " + this.dMin + " \"C\" " + this.dMax + " ]]";
    }

    @Override
    public Object getValueFromChoice(long choice, long maxNumChoices) {
        return this.dMin + (this.dMax - this.dMin) * (double)choice / (double)(maxNumChoices - 1L);
    }

    @Override
    public long getChoiceIndexFromValue(Object val, long maxNumChoices) {
        if (!(val instanceof Number)) {
            throw new IllegalStateException("Type mismatch: can't represent a non-number using this double-valued parameter specification.");
        }
        double dVal = ((Number)val).doubleValue();
        return StrictMath.round((dVal - this.dMin) * (double)(maxNumChoices - 1L) / (this.dMax - this.dMin));
    }
}

