/*
 * Decompiled with CFR 0.152.
 */
package bsearch.util;

import bsearch.util.SimpleDiGraph;
import java.io.FileNotFoundException;
import org.nlogo.agent.Observer;
import org.nlogo.api.CompilerException;
import org.nlogo.api.JobOwner;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;

public class TempTest {
    static String formatAxisLabelString(double d) {
        String s = Double.toString(d);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        System.out.println("*" + s);
        if (s.length() > 8) {
            s = String.format("%.3g", d);
        }
        return s.replace("e+0", "E").replace("e+", "E");
    }

    public static void main(String[] args) {
        HeadlessWorkspace workspace = HeadlessWorkspace.newInstance();
        try {
            Procedure p = workspace.compileReporter("ticks");
            SimpleJobOwner owner = new SimpleJobOwner("", new MersenneTwisterFast(), Observer.class);
            System.out.println("before running commands");
            Object obj = workspace.runCompiledReporter((JobOwner)owner, p);
            System.out.println("LLE: " + (Object)((Object)workspace.lastLogoException()));
            workspace.lastLogoException_$eq(null);
            System.out.println("returned: " + obj);
            System.out.println("done");
        }
        catch (CompilerException e) {
            e.printStackTrace();
        }
        System.out.println("before running commands");
        Object obj = workspace.report("5+5");
        System.out.println("LLE: " + (Object)((Object)workspace.lastLogoException()));
        System.out.println("returned: " + obj);
        System.out.println("done");
        System.exit(0);
        try {
            SimpleDiGraph.readEdgeListFromFile("testgraph.txt");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        MersenneTwisterFast rng = new MersenneTwisterFast();
        double d = 0.99;
        int i = 0;
        while (i < 10000) {
            double rand = rng.nextGaussian() * 0.05;
            System.out.println(String.valueOf(d) + " " + rand);
            d = (d + rand) % 1.0;
            if (d < 0.0) {
                System.err.println("negative!");
                System.exit(0);
            } else if (d >= 1.0) {
                System.err.println("> 1");
                System.exit(0);
            }
            ++i;
        }
        System.out.println(TempTest.formatAxisLabelString(-123.456789));
        System.out.println(TempTest.formatAxisLabelString(-123.4));
        System.out.println(TempTest.formatAxisLabelString(-123.0));
        System.out.println(TempTest.formatAxisLabelString(-1234.0));
        System.out.println(TempTest.formatAxisLabelString(-12345.0));
        System.out.println(TempTest.formatAxisLabelString(-1.23456789E8));
        System.out.println(TempTest.formatAxisLabelString(-1.23456789E113));
        System.out.println(TempTest.formatAxisLabelString(1.2345678E7));
    }
}

