/*
 * Decompiled with CFR 0.152.
 */
package bsearch.algorithms;

import bsearch.algorithms.AbstractSearchMethod;
import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.evaluation.SearchManager;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.SearchSpace;
import java.util.HashMap;
import org.nlogo.util.MersenneTwisterFast;

@Deprecated
public strictfp class GenerationalGA
extends AbstractSearchMethod {
    private double mutationRate = 0.01;
    private double crossoverRate = 0.7;
    private int populationSize = 50;

    @Override
    public String getName() {
        return "GenerationalGA";
    }

    @Override
    public String getDescription() {
        return "A standard generational Genetic Algorithm wherein a new full replacement population is created in each generation. (Uses tournament selection with tournament size 3)";
    }

    @Override
    public void setSearchParams(HashMap<String, String> searchMethodParams) throws SearchParameterException {
        this.mutationRate = this.validDoubleParam(searchMethodParams, "mutation-rate", 0.0, 1.0);
        this.crossoverRate = this.validDoubleParam(searchMethodParams, "crossover-rate", 0.0, 1.0);
        this.populationSize = this.validIntParam(searchMethodParams, "population-size", 2, 1000);
    }

    @Override
    public HashMap<String, String> getSearchParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mutation-rate", Double.toString(this.mutationRate));
        params.put("crossover-rate", Double.toString(this.crossoverRate));
        params.put("population-size", Integer.toString(this.populationSize));
        return params;
    }

    @Override
    public HashMap<String, String> getSearchParamsHelp() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mutation-rate", "likelihood of mutation occurring in each child");
        params.put("crossover-rate", "probability of using two parents to create a child (otherwise child is created asexually)");
        params.put("population-size", "the number of individuals in each generation");
        return params;
    }

    @Override
    public void search(SearchSpace space, ChromosomeFactory cFactory, SearchProtocol protocol, SearchManager manager, MersenneTwisterFast rng) throws BehaviorSearchException, NetLogoLinkException, InterruptedException {
        Chromosome[] population = new Chromosome[this.populationSize];
        Chromosome[] newpopulation = new Chromosome[this.populationSize];
        int i = 0;
        while (i < this.populationSize) {
            population[i] = cFactory.createChromosome(space, rng);
            ++i;
        }
        double[] fitness = manager.computeFitnessBatch(population, protocol.fitnessSamplingReplications, rng);
        while (!manager.searchFinished()) {
            int crossoverPairs = (int)(this.crossoverRate * (double)this.populationSize / 2.0);
            int newPopIndex = 0;
            int i2 = 0;
            while (i2 < crossoverPairs) {
                Chromosome p1 = manager.tournamentSelect(population, fitness, 3, rng);
                Chromosome p2 = manager.tournamentSelect(population, fitness, 3, rng);
                Chromosome[] children = p1.crossoverWith(p2, rng);
                newpopulation[newPopIndex++] = children[0];
                newpopulation[newPopIndex++] = children[1];
                ++i2;
            }
            while (newPopIndex < this.populationSize) {
                newpopulation[newPopIndex++] = manager.tournamentSelect(population, fitness, 3, rng);
            }
            i2 = 0;
            while (i2 < this.populationSize) {
                newpopulation[i2] = newpopulation[i2].mutate(this.mutationRate, rng);
                ++i2;
            }
            Chromosome[] temp = population;
            population = newpopulation;
            newpopulation = temp;
            fitness = manager.computeFitnessBatch(population, protocol.fitnessSamplingReplications, rng);
        }
    }
}

