/*
 * Decompiled with CFR 0.152.
 */
package bsearch.evaluation;

import bsearch.app.SearchProtocol;
import bsearch.evaluation.FitnessFunction;
import bsearch.evaluation.ResultsArchive;
import bsearch.nlogolink.ModelRunResult;
import bsearch.representations.Chromosome;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public strictfp class StandardFitnessFunction
implements FitnessFunction {
    private final SearchProtocol protocol;

    public StandardFitnessFunction(SearchProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public HashMap<Chromosome, Integer> getRunsNeeded(Chromosome point, int repetitionsRequested, ResultsArchive archive) {
        LinkedHashMap<Chromosome, Integer> map = new LinkedHashMap<Chromosome, Integer>(1);
        map.put(point, StrictMath.max(0, repetitionsRequested - archive.getResultsCount(point)));
        return map;
    }

    @Override
    public int getMaximumRunsThatCouldBeNeeded(int repetitionsRequested) {
        return repetitionsRequested;
    }

    @Override
    public double evaluate(Chromosome point, ResultsArchive archive) {
        List<ModelRunResult> resultsSoFar = archive.getResults(point);
        LinkedList<Double> condensedResults = new LinkedList<Double>();
        for (ModelRunResult result : resultsSoFar) {
            LinkedList<Double> singleRunHistory = result.getPrimaryTimeSeries();
            double dResult = this.protocol.fitnessCollecting.collectFrom(singleRunHistory);
            condensedResults.add(dResult);
        }
        return this.protocol.fitnessCombineReplications.combine(condensedResults);
    }

    @Override
    public double compare(double v1, double v2) {
        if (this.protocol.fitnessMinimized) {
            return v2 - v1;
        }
        return v1 - v2;
    }

    @Override
    public boolean strictlyBetterThan(double v1, double v2) {
        return this.compare(v1, v2) > 0.0;
    }

    @Override
    public double getWorstConceivableFitnessValue() {
        return this.protocol.fitnessMinimized ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getBestConceivableFitnessValue() {
        return this.protocol.fitnessMinimized ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean reachedStopGoalFitness(double fitness) {
        return false;
    }
}

