/*
 * Decompiled with CFR 0.152.
 */
package bsearch.representations;

import bsearch.representations.BinaryChromosome;
import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.SearchSpace;
import java.util.LinkedHashMap;
import org.nlogo.util.MersenneTwisterFast;

public strictfp class GrayBinaryChromosome
extends BinaryChromosome {
    public GrayBinaryChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
        super(searchSpace, rng);
    }

    public GrayBinaryChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
        super(searchSpace, paramSettings);
    }

    public GrayBinaryChromosome(boolean[] bitstring, SearchSpace searchSpace) {
        super(bitstring, searchSpace);
    }

    @Override
    public GrayBinaryChromosome clone() {
        return new GrayBinaryChromosome(this.bitstring, this.searchSpace);
    }

    @Override
    public void binaryEncode(long binval, boolean[] graybits, int offset, int len) {
        long gray = binval ^ binval >> 1;
        long bitMask = 1L;
        int i = 0;
        while (i < len) {
            graybits[offset + i] = (gray & bitMask) != 0L;
            bitMask <<= 1;
            ++i;
        }
    }

    @Override
    public long binaryDecode(boolean[] graybits, int offset, int len) {
        long bitMask = 1L << len - 1;
        long result = 0L;
        boolean previousBit = false;
        if (graybits[offset + len - 1]) {
            result |= bitMask;
            previousBit = true;
        }
        bitMask >>= 1;
        int i = len - 2;
        while (i >= 0) {
            if (previousBit ^ graybits[offset + i]) {
                result |= bitMask;
                previousBit = true;
            } else {
                previousBit = false;
            }
            bitMask >>= 1;
            --i;
        }
        return result;
    }

    public strictfp static class Factory
    implements ChromosomeFactory {
        @Override
        public Chromosome createChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
            return new GrayBinaryChromosome(searchSpace, rng);
        }

        @Override
        public Chromosome createChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
            return new GrayBinaryChromosome(searchSpace, paramSettings);
        }

        @Override
        public String getHTMLHelpText() {
            return "<strong>GrayBinaryChromosome</strong> Similar to StandardBinaryChromosome, except that numeric values are encoded to binary strings using a Gray code, instead of the standard 'high order' bit ordering. Gray codes have generally been found to give better performance for search representations, since numeric values that are close together are more likely to be fewer mutations away from each other.";
        }
    }
}

