/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.nlogolink.Utils;
import bsearch.space.CategoricalSpec;
import bsearch.space.ConstantSpec;
import bsearch.space.DoubleContinuousSpec;
import bsearch.space.DoubleDiscreteSpec;
import java.util.List;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

public strictfp abstract class ParameterSpec {
    String name;

    public ParameterSpec(String name) {
        this.name = name;
    }

    public String getParameterName() {
        return this.name;
    }

    public abstract Object generateRandomValue(MersenneTwisterFast var1);

    public abstract Object mutate(Object var1, double var2, MersenneTwisterFast var4);

    public abstract Object getValueFromChoice(long var1, long var3);

    public abstract long getChoiceIndexFromValue(Object var1, long var2);

    public abstract int choiceCount();

    public static ParameterSpec fromString(String paramString) {
        try {
            Object obj = Utils.evaluateNetLogoReporterInEmptyWorkspace(paramString);
            if (obj instanceof LogoList) {
                LogoList lst = (LogoList)obj;
                String name = (String)lst.get(0);
                obj = lst.get(1);
                if (obj instanceof LogoList) {
                    LogoList innerLst = (LogoList)obj;
                    if (innerLst.size() != 3) {
                        throw new IllegalArgumentException("Invalid parameter range spec: " + paramString);
                    }
                    Double dMin = (Double)innerLst.get(0);
                    Object incr = innerLst.get(1);
                    if (incr instanceof Double) {
                        Double dStep = (Double)incr;
                        Double dMax = (Double)innerLst.get(2);
                        return new DoubleDiscreteSpec(name, dMin, dStep, dMax);
                    }
                    if (incr.toString().equals("C")) {
                        Double dMax = (Double)innerLst.get(2);
                        return new DoubleContinuousSpec(name, dMin, dMax);
                    }
                    throw new IllegalArgumentException("Invalid ranged parameter spec, increment must be either \"C\" or a number. " + paramString);
                }
                if (lst.size() > 2) {
                    return new CategoricalSpec(name, (List<Object>)lst.butFirst());
                }
                return new ConstantSpec(name, lst.get(1));
            }
            throw new IllegalArgumentException("Invalid parameter spec: " + paramString + " | Object=" + obj);
        }
        catch (Exception ex) {
            if (ex instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)ex;
            }
            throw new IllegalArgumentException("Invalid parameter range spec: " + paramString + ".  Error was " + ex.getMessage(), ex);
        }
    }
}

