/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.app.BehaviorSearch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.nlogo.util.MersenneTwisterFast;

public class RunOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanelNorth = new JPanel();
    private JPanel jPanelSouth;
    private JButton jButtonCancel;
    private JLabel jLabelNumSearches;
    private JSpinner jSpinnerThreads;
    private JLabel jLabelThreads;
    private JSpinner jSpinnerNumSearches;
    private JPanel jPanelCenter;
    private JButton jButtonStartSearch;
    private boolean dialogCanceled = true;
    private JCheckBox jCheckBoxBriefOutput;
    private JButton jButtonNewSeed;
    private JPanel jPanel1;
    private JSpinner jSpinnerFirstSearchNumber;
    private JLabel jLabelFirstSearchNumber;
    private JSpinner jSpinnerRandomSeed;
    private JLabel jLabelRandomSeed;
    private JButton jButtonBrowseStem;
    private JTextField jTextFieldOutputStem;
    private JLabel jLabelOutputStem;

    public RunOptionsDialog(JFrame frame, BehaviorSearch.RunOptions runOptions) {
        super((Frame)frame, "Choose experiment running options");
        BorderLayout jPanelNorthLayout = new BorderLayout();
        this.jPanelNorth.setLayout(jPanelNorthLayout);
        this.getContentPane().add((Component)this.jPanelNorth, "North");
        this.jLabelOutputStem = new JLabel();
        this.jPanelNorth.add((Component)this.jLabelOutputStem, "West");
        this.jLabelOutputStem.setText("Output file stem:  ");
        this.jLabelOutputStem.setFont(new Font("Dialog", 1, 12));
        this.jTextFieldOutputStem = new JTextField();
        this.jPanelNorth.add((Component)this.jTextFieldOutputStem, "Center");
        this.jTextFieldOutputStem.setText("/path/to/some/filename/stem");
        this.jTextFieldOutputStem.setToolTipText("All of the output files will start with the same filename \"stem\" (e.g.  MYSTEM.bestHistory.csv, MYSTEM.finalBests.csv)");
        this.jButtonBrowseStem = new JButton();
        this.jPanelNorth.add((Component)this.jButtonBrowseStem, "East");
        this.jButtonBrowseStem.setText("Browse...");
        this.jButtonBrowseStem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser("./experiments/");
                chooser.setSelectedFile(new File(RunOptionsDialog.this.jTextFieldOutputStem.getText()));
                int returnVal = chooser.showSaveDialog(RunOptionsDialog.this);
                if (returnVal == 0) {
                    RunOptionsDialog.this.jTextFieldOutputStem.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        this.jPanelNorth.setPreferredSize(new Dimension(190, 35));
        this.jPanelSouth = new JPanel();
        FlowLayout jPanelSouthLayout = new FlowLayout();
        jPanelSouthLayout.setAlignment(2);
        this.jPanelSouth.setLayout(jPanelSouthLayout);
        this.getContentPane().add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.setPreferredSize(new Dimension(190, 35));
        this.jButtonStartSearch = new JButton("Start Search");
        this.jPanelSouth.add(this.jButtonStartSearch);
        this.jButtonStartSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RunOptionsDialog.this.dialogCanceled = false;
                RunOptionsDialog.this.setVisible(false);
            }
        });
        this.jButtonCancel = new JButton();
        this.jPanelSouth.add(this.jButtonCancel);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RunOptionsDialog.this.setVisible(false);
            }
        });
        this.jPanelCenter = new JPanel();
        this.getContentPane().add((Component)this.jPanelCenter, "Center");
        GridBagLayout jPanel2Layout = new GridBagLayout();
        jPanel2Layout.columnWidths = new int[]{7, 7};
        jPanel2Layout.rowHeights = new int[]{7, 7, 7, 7, 7};
        jPanel2Layout.columnWeights = new double[]{0.1, 0.1};
        jPanel2Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1};
        this.jPanelCenter.setLayout(jPanel2Layout);
        this.jLabelNumSearches = new JLabel();
        this.jPanelCenter.add((Component)this.jLabelNumSearches, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jLabelNumSearches.setText("Number of searches:");
        this.jLabelNumSearches.setFont(new Font("Dialog", 1, 12));
        SpinnerNumberModel jSpinnerNumSearchesModel = new SpinnerNumberModel(1, 1, 10000, 1);
        this.jSpinnerNumSearches = new JSpinner();
        this.jPanelCenter.add((Component)this.jSpinnerNumSearches, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jSpinnerNumSearches.setModel(jSpinnerNumSearchesModel);
        this.jSpinnerNumSearches.setToolTipText("How many times should this search be repeated?");
        this.jLabelThreads = new JLabel();
        this.jPanelCenter.add((Component)this.jLabelThreads, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jLabelThreads.setText("Number of threads:");
        this.jLabelThreads.setToolTipText("(only affects search time performance, not search results)");
        this.jLabelThreads.setFont(new Font("SansSerif", 1, 12));
        SpinnerNumberModel jSpinnerThreadsModel = new SpinnerNumberModel(1, 1, 32, 1);
        this.jSpinnerThreads = new JSpinner();
        this.jPanelCenter.add((Component)this.jSpinnerThreads, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jSpinnerThreads.setModel(jSpinnerThreadsModel);
        this.jSpinnerThreads.setToolTipText("(only affects search time performance, not search results)");
        this.jLabelRandomSeed = new JLabel();
        this.jPanelCenter.add((Component)this.jLabelRandomSeed, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jLabelRandomSeed.setText("Initial random seed:");
        this.jLabelRandomSeed.setFont(new Font("SansSerif", 1, 12));
        this.jPanel1 = new JPanel();
        BorderLayout jPanel1Layout = new BorderLayout();
        this.jPanel1.setLayout(jPanel1Layout);
        this.jPanelCenter.add((Component)this.jPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        SpinnerNumberModel jSpinnerRandomSeedModel = new SpinnerNumberModel(1, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.jSpinnerRandomSeed = new JSpinner();
        this.jPanel1.add((Component)this.jSpinnerRandomSeed, "Center");
        this.jSpinnerRandomSeed.setModel(jSpinnerRandomSeedModel);
        this.jSpinnerRandomSeed.setToolTipText("random seed to be used for the first search (additional searches will be seeded with following consecutive numbers)");
        this.jButtonNewSeed = new JButton();
        this.jPanel1.add((Component)this.jButtonNewSeed, "East");
        this.jButtonNewSeed.setText("New");
        this.jButtonNewSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunOptionsDialog.this.jSpinnerRandomSeed.setValue(new MersenneTwisterFast().nextInt());
            }
        });
        this.jLabelFirstSearchNumber = new JLabel();
        this.jPanelCenter.add((Component)this.jLabelFirstSearchNumber, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jLabelFirstSearchNumber.setText("Starting at search ID:");
        this.jLabelFirstSearchNumber.setFont(new Font("Dialog", 1, 12));
        SpinnerNumberModel jSpinnerFirstSearchNumberModel = new SpinnerNumberModel(1, 0, 10000, 1);
        this.jSpinnerFirstSearchNumber = new JSpinner();
        this.jPanelCenter.add((Component)this.jSpinnerFirstSearchNumber, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.jSpinnerFirstSearchNumber.setModel(jSpinnerFirstSearchNumberModel);
        this.jSpinnerFirstSearchNumber.setToolTipText("What number should the \"search ID\" numbers start at, in the output files?");
        this.jCheckBoxBriefOutput = new JCheckBox();
        this.jPanelCenter.add((Component)this.jCheckBoxBriefOutput, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jCheckBoxBriefOutput.setText("Brief Output?");
        this.jCheckBoxBriefOutput.setToolTipText("Do not create the two largest files, with ALL of the model run and objective function data.");
        this.jCheckBoxBriefOutput.setFont(new Font("Dialog", 1, 12));
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                RunOptionsDialog.this.jButtonStartSearch.requestFocusInWindow();
            }
        });
        this.init(runOptions);
        this.setPreferredSize(new Dimension(600, 280));
        this.pack();
    }

    public void init(BehaviorSearch.RunOptions runOptions) {
        this.jTextFieldOutputStem.setText(runOptions.outputStem);
        this.jSpinnerNumSearches.setValue(runOptions.numSearches);
        this.jSpinnerFirstSearchNumber.setValue(runOptions.firstSearchNumber);
        this.jSpinnerThreads.setValue(runOptions.numThreads);
        this.jSpinnerRandomSeed.setValue((int)runOptions.randomSeed);
        this.jCheckBoxBriefOutput.setSelected(runOptions.briefOutput);
    }

    public void updateOptions(BehaviorSearch.RunOptions runOptions) {
        runOptions.outputStem = this.jTextFieldOutputStem.getText();
        runOptions.numSearches = (Integer)this.jSpinnerNumSearches.getValue();
        runOptions.firstSearchNumber = (Integer)this.jSpinnerFirstSearchNumber.getValue();
        runOptions.numThreads = (Integer)this.jSpinnerThreads.getValue();
        runOptions.randomSeed = (Integer)this.jSpinnerRandomSeed.getValue();
        runOptions.briefOutput = this.jCheckBoxBriefOutput.isSelected();
    }

    public static boolean showDialog(JFrame parent, BehaviorSearch.RunOptions runOptions) {
        RunOptionsDialog dialog = new RunOptionsDialog(parent, runOptions);
        dialog.setLocationRelativeTo(null);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        if (dialog.dialogCanceled) {
            return false;
        }
        dialog.updateOptions(runOptions);
        return true;
    }
}

